<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
}

include 'include/head.php';
include 'include/navigation.php';
?>

    <!-- Page Content -->
    <div id="page-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <h1 class="page-header">Bienvenue <?php echo htmlspecialchars($_SESSION['user']) ?></h1>
                </div>
                <!-- /.col-lg-12 -->
            </div>
            <!-- /.row -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            Liste des groupes et leurs élèves (cliquez sur un groupe pour le modifier)
                        </div>
                        <!-- /.panel-heading -->
                        <div class="panel-body">
                            <div class="dataTable_wrapper">
                                <table class="table table-striped table-bordered table-hover" id="dataTables-example">
                                    <thead>
                                    <tr>
                                        <th>Nom du groupe</th>
                                        <th>Nom</th>
                                        <th>Prénom</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    $result = $bdd->query("SELECT id, nom FROM groupe");
                                    $result->execute();
                                    while ($ligne = $result->fetch())
                                    {
                                        $requete = $bdd->prepare("SELECT id_eleve4 FROM groupe_eleve WHERE id_groupe=:id");
                                        $requete->bindParam(':id', $ligne['id']);
                                        $requete->execute();
                                        if ($requete->rowCount() > 0) {
                                            while ($id_eleve = $requete->fetch())
                                            {
                                                $requete2 = $bdd->prepare("SELECT nom, prenom FROM eleve WHERE id_eleve=:id");
                                                $requete2->bindParam(':id', $id_eleve['id_eleve4']);
                                                $requete2->execute();
                                                $row = $requete2->fetch();
                                                ?>
                                                <tr class="odd">
                                                    <td><a href="edition-groupe.php?id=<?php echo htmlspecialchars($ligne['id']) ?>"><?php echo htmlspecialchars($ligne['nom']) ?></a></td>
                                                    <td><?php echo htmlspecialchars($row['nom']) ?></td>
                                                    <td><?php echo htmlspecialchars($row['prenom']) ?></td>
                                                </tr>
                                                <?php
                                            }
                                        }
                                        else {
                                            ?>
                                            <tr class="odd">
                                                <td><a href="edition-groupe.php?id=<?php echo htmlspecialchars($ligne['id']) ?>"><?php echo htmlspecialchars($ligne['nom']) ?></a></td>
                                                <td>Aucun élève</td>
                                                <td>Aucun élève</td>
                                            </tr>
                                            <?php
                                        }
                                    }
                                    ?>
                                    </tbody>
                                </table>
                            </div>
                            <!-- /.table-responsive -->
                        </div>
                        <!-- /.panel-body -->
                    </div>
                    <!-- /.panel -->
                </div>
                <!-- /.col-lg-12 -->
            </div>
        </div>
        <!-- /.container-fluid -->
    </div>
    <!-- /#page-wrapper -->

<?php
include 'include/foot.php';
